/// @ref core
/// @file glm/ext/vector_float4.hpp

#pragma once
#include "../detail/type_vec4.hpp"

namespace glm
{
	/// @addtogroup core_vector
	/// @{

	/// 4 components vector of single-precision floating-point numbers.
	///
	/// @see <a href="http://www.opengl.org/registry/doc/GLSLangSpec.4.20.8.pdf">GLSL 4.20.8 specification, section 4.1.5 Vectors</a>
	typedef vec<4, float, defaultp>		vec4;

	/// @}
}//namespace glm

#if GLM_CONFIG_CTOR_INIT == GLM_DISABLE
static_assert(std::is_trivially_default_constructible<glm::vec4>::value);
#endif
static_assert(std::is_trivially_copy_assignable<glm::vec4>::value);
static_assert(std::is_trivially_copyable<glm::vec4>::value);
static_assert(std::is_copy_constructible<glm::vec4>::value);
static_assert(glm::vec4::length() == 4);

